<?php
/*--------------------------------------------------------------
   Boolean.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Row\Field;

use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Row\Field;
use Webmozart\Assert\Assert;

class Boolean implements Field
{
    /**
     * @var string
     */
    private $name;
    
    /**
     * @var bool
     */
    private $value;
    
    
    /**
     * Constructor.
     */
    private function __construct(string $name, bool $value)
    {
        Assert::stringNotEmpty($name);
        
        $this->name  = $name;
        $this->value = $value;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(string $name, bool $value): self
    {
        return new self($name, $value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function name(): string
    {
        return $this->name;
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): bool
    {
        return $this->value;
    }
}